function makeT()

%%%% This matlab function generates daily temperature variations 
%%%% throughout a year and saves to Temp.input file that can be 
%%%% used with int_frost_10.c

close all;

dTa = 0; %Annual temperature oscillation amplitude
dTdm = 3; %mean daily temperature oscillation
dTdv = 2; %variation in daily temperature oscillation

npd = 100; %time steps per day
N = npd*365;
dt = 1/npd; %timestep

T = zeros(N,1);
time = linspace(0,365,N);

for i = 1:365,
  
  Tdm = dTa*sin(2*pi*i/365);
  
  dTd = dTdm + 2*(rand(1)-.5)*dTdv;
  
  %provide damping due to snow cover
  sfac = 0.5*(sin(2*pi*i/365)+1);
  sfac = 1; %No dampening/snow when sfac=1
  
  for j = 1:npd,
    
    index = (i-1)*npd+j;
    
    T(index) = Tdm + sfac*dTd*sin(2*pi*j/npd);
    
  end;
  
end;

hold on; box on; grid on;
plot(time,T,'-k');

save Tdata.mat time T;

fid = fopen('../source/Temp.input','wb');
fwrite(fid,N,'int');
fwrite(fid,dt,'double');
fwrite(fid,T,'double');
fclose(fid);


    
  
